import arrow
from fastapi import APIRouter, Request, Body, status
from typing import Dict, List
from fastapi.encoders import jsonable_encoder
from fastapi.responses import JSONResponse
from lib.common import *
import json

router = APIRouter()

@router.get("/get_uom/{uom_id}")
async def get_uom(request: Request, uom_id):
    cursor = request.app.mssql.cursor()

    if uom_id != '0':
        rows = cursor.execute("select SpecificationTypeId,Name from SpecificationType where SpecificationTypeId = ?",uom_id)
    else:
        rows = cursor.execute("select SpecificationTypeId,Name from SpecificationType")


    uom_data = []
    if rows.rowcount != 0:
        for row in rows:
            uom_data.append({
                "uom_id": row[0],
                "uom_name": row[1]
            })
        if len(uom_data) > 1:
            return uom_data
        else:
            return uom_data[0]
    else:
        return "uom not found"