import arrow
from fastapi import APIRouter, Request, Body, status
from typing import Dict, List
from fastapi.encoders import jsonable_encoder
from fastapi.responses import JSONResponse
from lib.common import *
import json

router = APIRouter()

@router.get("/get_product_name/{filter}")
async def get_product_name(request: Request, filter):
    cursor = request.app.mssql.cursor()

    if filter == '0':
        rows = cursor.execute("select top 20 PAT.Name,PT.ProductId from ProductTranslation PT inner join Vaaak.ProductAdditionalTranslation PAT on PT.ProductAdditionalTransId = PAT.ProductAdditionalTransId")
    else:
        rows = cursor.execute(
            "select top 20 PAT.Name,PT.ProductId from ProductTranslation PT inner join Vaaak.ProductAdditionalTranslation PAT on PT.ProductAdditionalTransId = PAT.ProductAdditionalTransId where name like '{}%'".format(filter))

    product_data = []
    if rows.rowcount != 0:
        for row in rows:
            product_data.append({
                "product_name": row[0],
                "product_id": row[1]
            })
        return product_data
    else:
        return []