import arrow
from fastapi import APIRouter, Request, Body, status
from typing import Dict, List
from fastapi.encoders import jsonable_encoder
from fastapi.responses import JSONResponse
from lib.common import *
import json

router = APIRouter()

@router.get("/get_vendor/{details}/{vendor_id}")
async def get_vendor(request: Request, details, vendor_id):
    cursor = request.app.mssql.cursor()
    if details == '1':
        if vendor_id != '0':
            rows = cursor.execute("select * from Vaaak.Vendor where VendorId = ?", vendor_id)
        else:
            rows = cursor.execute("select * from Vaaak.Vendor")

        vendor_data = []
        if rows.rowcount != 0:
            for row in rows:
                vendor_data.append({
                    "id": row[0],
                    "name": row[1],
                    "address": row[2],
                    "country_code": row[3],
                    "mobile": row[4],
                    "gst": row[5],
                })
            if len(vendor_data) > 1:
                return vendor_data
            else:
                return vendor_data[0]
        else:
            return "vendor not found"

    else:
        if vendor_id != '0':
            rows = cursor.execute("select VendorId,VendorName from Vaaak.Vendor where VendorId = ?",vendor_id)
        else:
            rows = cursor.execute("select VendorId,VendorName from Vaaak.Vendor")


        vendor_data = []
        if rows.rowcount != 0:
            for row in rows:
                vendor_data.append({
                    "vendor_id": row[0],
                    "vendor_name": row[1]
                })

            if len(vendor_data) > 1:
                return vendor_data
            else:
                return vendor_data[0]

        else:
            return "vendor not found"

@router.post("/create_vendor")
async def create_vendor(request : Request, vendor_details : Dict = Body(...)):
    vendor_details = jsonable_encoder(vendor_details)

    cursor = request.app.mssql.cursor()
    try:
        cursor.execute("insert into Vaaak.Vendor(VendorName, VendorAddress, CountryCode, MobileNo, GSTIN, CreatedDate, Remarks) values (?, ?, ?, ?, ?, ?, ?)",
                       vendor_details['name'],
                       vendor_details['address'],
                       vendor_details['country_code'],
                       vendor_details['mobile'],
                       vendor_details['gst'],
                       arrow.now().replace(tzinfo='Asia/Calcutta').datetime,
                       vendor_details['remarks']
                       )

        request.app.mssql.commit()
        return "vendor created"

    except Exception as e:
        return "Vendor not created"


