# packages
import uvicorn

from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware
import pyodbc

# settings
from config.base import settings

# routes import
from routes.purchase_order import router as purchase_order_router
from routes.grn import router as grn_router
from routes.vendor import router as vendor_router
from routes.others import router as others_router
from routes.products import router as products_router
from routes.dashboard import router as dashboard_router
# from routes.index_router import router as index_router

app = FastAPI()

app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)



@app.on_event("startup")
async def startup_event():

    app.mssql = pyodbc.connect('Driver={};'
                                      'Server={};'
                                      'Database={};'
                                      'UID={};'
                                      'PWD={};'
                                      'Trusted_Connection=no;'
                                       'autocommit=True'
                                      .format(settings.DB_DRIVER,settings.DB_SERVER,settings.DB_NAME,settings.DB_USER, settings.DB_PWD))


@app.on_event("shutdown")
async def shutdown_event():
    app.mssql.close()

app.include_router(purchase_order_router, tags=['purchase_order_router'], prefix='/api/v1')
app.include_router(grn_router, tags=['grn_router'], prefix='/api/v1')
app.include_router(vendor_router, tags=['vendor_router'], prefix='/api/v1')
app.include_router(others_router, tags=['others_router'], prefix='/api/v1')
app.include_router(products_router, tags=['products_router'], prefix='/api/v1')
app.include_router(dashboard_router, tags=['dashboard'], prefix='/api/v1')
# app.include_router(index_router, tags=['index'])

if __name__ == "__main__":
    uvicorn.run(
        "main:app",
        host=settings.HOST,
        reload=settings.DEBUG_MODE,
        port=settings.PORT,
    )
