import arrow
from fastapi import APIRouter, Request, Body, status
from typing import Dict, List
from fastapi.encoders import jsonable_encoder
from fastapi.responses import JSONResponse
from lib.common import *
import json

router = APIRouter()

@router.get("/get_vendor/{details}/{vendor_id}")
async def get_vendor(request: Request, details, vendor_id):
    cursor = request.app.mssql.cursor()
    if details == '1':
        if vendor_id != '0':
            rows = cursor.execute("select * from Vaaak.Vendor where VendorId = ?", vendor_id)
        else:
            rows = cursor.execute("select * from Vaaak.Vendor")

        vendor_data = []
        if rows.rowcount != 0:
            for row in rows:
                if row:
                    temp_row = {}
                    for itr, itr_itm in enumerate(row):
                        temp_row[row.cursor_description[itr][0]] = itr_itm
                    vendor_data.append(temp_row)
            json_serializer(vendor_data)
            if len(vendor_data) > 1:
                return vendor_data
            else:
                return vendor_data[0]
        else:
            return "vendor not found"

    else:
        if vendor_id != '0':
            rows = cursor.execute("select VendorId,VendorName from Vaaak.Vendor where VendorId = ?",vendor_id)
        else:
            rows = cursor.execute("select VendorId,VendorName from Vaaak.Vendor")


        vendor_data = []
        if rows.rowcount != 0:
            for row in rows:
                vendor_data.append({
                    "vendor_id": row[0],
                    "vendor_name": row[1]
                })

            if len(vendor_data) > 1:
                return vendor_data
            else:
                return vendor_data[0]

        else:
            return "vendor not found"

@router.post("/create_vendor")
async def create_vendor(request : Request, vendor_details : Dict = Body(...)):
    vendor_details = jsonable_encoder(vendor_details)

    cursor = request.app.mssql.cursor()
    try:
        cursor.execute(
            "insert into Vaaak.Vendor(VendorName,VendorAddress1,VendorAddress2,City,State,Country,CountryCode,MobileNo,landlineNo,GSTIN,CreatedDate,Last_Update,Remarks) values(?,?,?,?,?,?,?,?,?,?,?,GETDATE(),?)",
            vendor_details['name'],
            vendor_details['address1'],
            vendor_details.get('address2') or None,
            vendor_details['city'],
            vendor_details['state'],
            vendor_details['country'],
            vendor_details['country_code'],
            vendor_details['mobile'],
            vendor_details.get('landline') or None,
            vendor_details['gst'],
            arrow.now().replace(tzinfo='Asia/Calcutta').datetime,
            vendor_details.get('remarks') or None
            )

        request.app.mssql.commit()
        return "vendor created"

    except Exception as e:
        return "Vendor not created"


