from pydantic import BaseSettings


class CommonSettings(BaseSettings):
    APP_NAME: str = "ASTROVED"
    DEBUG_MODE: bool = False


class ServerSettings(BaseSettings):
    HOST: str = "0.0.0.0"
    PORT: int = 8000

##astroved_test_server
class DatabaseSettings(BaseSettings):
    DB_DRIVER: str = "SQL Server"
    DB_SERVER: str = "192.168.0.112\dbserver"
    DB_NAME: str = "VaaakDEV"
    DB_USER: str = "avpcadmin"
    DB_PWD: str = "astroved@108"

##local_config
# class DatabaseSettings(BaseSettings):
#     DB_DRIVER: str = "ODBC Driver 17 for SQL Server"
#     DB_SERVER: str = "LAPTOP-S1K5T3PJ"
#     DB_NAME: str = "astroved"
#     DB_USER: str = "sa"
#     DB_PWD: str = "astro1?ved"


class CorsSettings(BaseSettings):
    origins: list = [
        "http://localhost:8080",
        "http://localhost:3000",
        "http://127.0.01:8000",
        "http://localhost:5037"
    ]


class Settings(CommonSettings, ServerSettings, DatabaseSettings, CorsSettings):
    pass


settings = Settings()
