<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

	public function __construct() {

		parent::__construct();	
		$promo_as = '';
		if (!isset($_COOKIE['promo_as'])) {
			$actual_link 				= $_SERVER[HTTP_HOST];
			$promo_as = $_COOKIE['promo_as'];
			setcookie('promo_as', $actual_link, time() + 31556926); // 7 days
		}
    } 

	public function index()
	{
		$CustomerId = $this->session->userdata('CustomerId');
		$session_mobileno = $this->session->userdata('mobileno');

		if($session_mobileno == '' && $CustomerId == '') {
			$this->load->view('header');
			$this->load->view('home');
			$this->load->view('footer');
		} else {
			redirect(base_url().'home/registration');
		}
		
	}
	public function mobile_tab()
	{	
		$name = $_POST['name'];
		if(preg_match("/^[a-zA-Z \b]+$/", $name) == 1) {
			$this->session->set_userdata('username', $name);
			$this->load->view('mobile_tab');
		} else {
			?>
				<script type="text/javascript"> 
					jQuery(".name-error").text("Enter Valid Name"); 
				</script>
			<?php
		}
	}
	public function registration()
	{
		
		$post_type = $_POST['post_type'];
		
		if($post_type == 'home') {
			$mobilecode = $_POST['mobilecode'];
			$mobileno = $_POST['mobileno'];
			if(preg_match("/^[0-9]{1,15}$/", $mobileno) == 1) {
				$data = array("userLogin"=> $mobilecode."|".$mobileno, "shopName" => "AstroVed");
				$data = json_encode($data);
				$output = postrequesttoken(ASPX_SERVICE_URL.'Account/GenerateOtpForMobile',$data);
				$output = json_decode($output);
				if($output->message == 'Verification Code Sent Successfully') {
					?>
					 <div id="change-tab"></div>
					<script type="text/javascript"> 
						jQuery(".otp-code-error").text(""); 
					</script> <?php
					$this->session->set_userdata('mobileno', $mobileno);
					$this->session->set_userdata('mobilecode', $mobilecode);
					$this->session->set_userdata($mobileno.'_timeout', $output->LastUpdateDate);
					$mobile_detail['mobilecode'] = $mobilecode;
					$mobile_detail['mobileno'] = $mobileno;
					$mobile_detail['success_otp'] = "OTP sent successfully to your registered mobile Number";
					$this->load->view('verify_otp',$mobile_detail);
				} else {
					
					?>
					 <div id="change-tab"></div>
					<script type="text/javascript"> 
						jQuery(".otp-code-error").text("OTP not Sent Successfully"); 
					</script> <?php
				}
			} else {
				?>
				<script type="text/javascript">
					jQuery(".invalid").text("Enter Valid Mobile Number");
				</script>
				<?php
			}
		}else {
			$mobilecode = $this->input->post('mobilecode');
			$mobileno = $this->input->post('mobileno');
			$VerificationCode = $this->input->post('VerificationCode');
			$currentCurrency = $_COOKIE['cookiecurrency'];
			if($currentCurrency == '') {
				$currentCurrency = getcurrency();
			}
			$CustomerId = $this->session->userdata('CustomerId');
			$session_mobileno = $this->session->userdata('mobileno');
			$session_mobilecode = $this->session->userdata('mobilecode');
			$session_username = $this->session->userdata('username');
			if($mobilecode == '' && $mobileno == '') {
				$mobileno = $session_mobileno;
				$mobilecode = $session_mobilecode;
			}
			$this->form_validation->set_error_delimiters('<p class="error">', '</p>');
			$this->form_validation->set_rules('VerificationCode', 'OTP', 'trim|required|min_length[5]|max_length[6]|regex_match[/^[][0-9 ,]+$/]');

			if($session_mobileno != '' && $CustomerId == '') {
					if ($this->form_validation->run() == FALSE) {
						$data['mobilecode'] = $mobilecode;
						$data['mobileno'] = $mobileno;
						$data['astrologers'] = 'yes';
						$data['success_otp'] = "OTP sent successfully to your registered mobile Number";
						$this->load->view('header');
						$this->load->view('verify_otp', $data);
						$this->load->view('footer');
					} else {
						$data = array("FirstName" => $session_username, "LastName" => '', "userLogin" => $mobilecode."|".$mobileno, "shopName" => "AstroVed", "Currency" => $currentCurrency, "TrackingCode" => "loginwithmobileno", "VerificationCode" =>$VerificationCode);
						$data = json_encode($data);
						$output = postrequesttoken(ASPX_SERVICE_URL.'Account/MobileNoRegistration',$data);
						$output = json_decode($output);

						if($output->IsRegistered == 1) {
							$this->session->set_userdata('CustomerId',$output->CustomerId);
							setcookie("CustomerCurrency", $output->CustomerCurrency, time() + 31556926, '/');
							$add_data = array('customerId' => $output->CustomerId,'currency'=> $output->CustomerCurrency);
							$post_data = json_encode($add_data);
							$getwalletamount = postrequesttoken(ASPX_SERVICE_URL.'payment/GetWalletBalance', $post_data);
							$getwalletamount = json_decode($getwalletamount);
							$balance['getwalletamount'] = $getwalletamount;
							$balance['CustomerCurrency'] = $output->CustomerCurrency;
							$this->load->view('header');
							$this->load->view('all_astrologers',$balance);
							$this->load->view('footer');
						} else {
							$mobile_detail['mobilecode'] = $mobilecode;
							$mobile_detail['mobileno'] = $mobileno;
							$mobile_detail['astrologers'] = 'yes';
							$mobile_detail['invalid_otp'] = 'Enter valid OTP';
							$this->load->view('header');
							$this->load->view('verify_otp', $mobile_detail);
							$this->load->view('footer');
						}
					}
			} elseif ($session_mobileno == '' && $CustomerId == '') {
				redirect(base_url());
			} else {
				$CustomerId = $this->session->userdata('CustomerId');
				$add_data = array('customerId' => $CustomerId,'currency'=> $_COOKIE['CustomerCurrency']);
				$post_data = json_encode($add_data);
				$getwalletamount = postrequesttoken(ASPX_SERVICE_URL.'payment/GetWalletBalance', $post_data);
				$getwalletamount = json_decode($getwalletamount);
				$balance['getwalletamount'] = $getwalletamount;
				$this->load->view('header');
				$this->load->view('all_astrologers',$balance);
				$this->load->view('footer');
			}
		}
	}

	public function logout() {

		$mobileno = $this->session->unset_userdata('mobileno');
		$this->session->unset_userdata($mobileno.'_timeout');
		$this->session->unset_userdata('username');
		$this->session->unset_userdata('CustomerId');
		$this->session->unset_userdata('mobileno');
		$this->session->unset_userdata('mobilecode');
		$this->session->unset_userdata('re_amnt');

		setcookie("CustomerCurrency", '', time() + 31556926, '/');

		redirect(base_url());

	}
}
