var input_mobile = document.querySelector("#mobile"),
  errorMsg = document.querySelector("#error-msg"),
  validMsg = document.querySelector("#valid-msg");

// here, the index maps to the error code returned from getValidationError - see readme
var errorMap = ["Invalid mobile number", "Invalid country code", "Too short", "Too long", "Invalid mobile number"];

// initialise plugin
var iti = window.intlTelInput(input_mobile, {
  initialCountry: "auto",
  geoIpLookup: function(callback) {
    $.get('https://ipinfo.io', function() {}, "jsonp").always(function(resp) {
      var countryCode = (resp && resp.country) ? resp.country : "";
      callback(countryCode);
    });
  },
  preferredCountries: ['in', 'us'],
  separateDialCode: true,
  utilsScript: "template/front/vendor/mobile/js/utils.js"
  //utilsScript: window.location.origin+'/assets/js/utils.js'
});

var reset = function() {
  input_mobile.classList.remove("error");
  errorMsg.innerHTML = "";
  $('#mobile_data_error').val('');
  //errorMsg.classList.add("hide");
  //validMsg.classList.add("hide");
};

// on blur: validate
input_mobile.addEventListener('blur', function() {
  reset();
  if (input_mobile.value.trim()) {
    if (iti.isValidNumber()) {
      //validMsg.classList.remove("hide");
    } else {
      input_mobile.classList.add("error");
      var errorCode = iti.getValidationError();
      if(errorCode == 1){
        if($('#mobileCode').val() == ''){
            errorMsg.innerHTML = errorMap[errorCode];
            $('#mobile_data_error').val(errorMap[errorCode]);    
        }else{
            input_mobile.classList.remove("error");
        }
      }else{
        errorMsg.innerHTML = errorMap[errorCode];
        $('#mobile_data_error').val(errorMap[errorCode]);  
      }
      //errorMsg.classList.remove("hide");
    }
  }
});

input_mobile.addEventListener('keypress', function(e) {
  if(e.keyCode === 13) {
       
    if (input_mobile.value.trim()) {
      if (iti.isValidNumber()) {
        reset();
         $("#mobileno-btn").trigger("click");
      } else {
        input_mobile.classList.add("error");
        var errorCode = iti.getValidationError();
        if(errorCode == 1){
          if($('#mobileCode').val() == ''){
              errorMsg.innerHTML = errorMap[errorCode];
              $('#mobile_data_error').val(errorMap[errorCode]);    
          }else{
              input_mobile.classList.remove("error");
          }
        }else{
          errorMsg.innerHTML = errorMap[errorCode];
          $('#mobile_data_error').val(errorMap[errorCode]);  
        }
        //errorMsg.classList.remove("hide");
      }
    }
  }
  
});

// on keyup / change flag: reset
input_mobile.addEventListener('change', reset);
// input_mobile.addEventListener('keyup', reset);

$(function () {
  $("#mobile").keypress(function (e) {
      var keyCode = e.keyCode || e.which;

      //Regex for Valid Characters i.e. Alphabets.
      var regex = /^[0-9]+$/;

      //Validate TextBox value against the Regex.
      var isValid = regex.test(String.fromCharCode(keyCode));
      if(String.fromCharCode(keyCode) == '(' || String.fromCharCode(keyCode) == ')' || String.fromCharCode(keyCode) == '-' || String.fromCharCode(keyCode) == ' '){
          isValid = true;
      }
      if (!isValid) {
          $("#mobile").addClass('error');
          $("#mobile_data_error").val("Invalid mobile number");
         // $("#error-msg").html("Invalid number");
      }

      return isValid;
  });
});
